<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

define('THIS_SCRIPT', 'radioandtv_cleanup');



print_cp_header();


// cleanup options
if ( $_REQUEST['do'] == 'cleanup' ) {
	print_form_header(THIS_SCRIPT, 'cleanratings', 1, 1, 'cleanratingsForm');
	print_table_header(' ');
	print_label_row('  ,      /     .');
	print_submit_row('', 0);
	
	print_form_header(THIS_SCRIPT, 'cleanstations', 1, 1, 'cleanstationsForm');
	print_table_header(' ');
	print_label_row(' ,                .');
	print_submit_row('', 0);
}

// cleanup ratings
if ( $_REQUEST['do'] == 'cleanratings' ) {
	echo ' ...<br /><br />';
	
	$userless_ratings = rs_get_userless_ratings();
	
	echo '    :<br /><br />';
	
	foreach ($userless_ratings AS $rating) {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_rating
							WHERE ratingid = " . $rating['ratingid']);
		echo " : $rating[rating]  '" . htmlentities($rating['name']) . "'<br />";
	}
	
	if (empty($userless_ratings)) {
		echo ' <br />';
	}
	
	echo '<br />';
	
	$nopermission_ratings = rs_get_nopermission_ratings();
	
	echo '  ,      :<br /><br />';
	
	foreach ($nopermission_ratings AS $rating) {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation_rating
							WHERE ratingid = " . $rating['ratingid']);
		echo " : $rating[rating]  '" . htmlentities($rating['name']) . "'  () '" . htmlentities($rating['username']) . "'<br />";
	}
	
	if (empty($nopermission_ratings)) {
		echo ' <br />';
	}
	
	echo '<br /><br /><center>!</center>';
}

// cleanup stations
if ( $_REQUEST['do'] == 'cleanstations' ) {
	echo ' ...<br /><br />';
	
	$orphan_stations = rs_get_orphan_stations();
	
	echo '  (  ):<br /><br />';
	
	foreach ($orphan_stations AS $station) {
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "radiostation
							WHERE stationid = " . $station['stationid']);
		echo " '" . htmlentities($station['name']) . "' <br />";
	}
	
	if (empty($orphan_stations)) {
		echo ' <br />';
	}
	
	echo '<br /><br /><center>!</center>';
}



print_cp_footer();



// #######################################################################
// ############################ FUNCTIONS ################################
// #######################################################################

function rs_get_userless_ratings() {
	global $db;
	$list = array();
	$results = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "radiostation_rating AS r
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS s ON (s.stationid = r.stationid)
				LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = r.userid)
				WHERE u.username IS NULL");
	while( $item = $db->fetch_array( $results ) ) {
		$list[] = $item;
	}
	return $list;
}

function rs_get_nopermission_ratings() {
	global $db, $vbulletin;
	$userids = array();
	$results = $db->query_read("SELECT DISTINCT(userid) FROM " . TABLE_PREFIX . "radiostation_rating");
	while( $item = $db->fetch_array( $results ) ) {
		$userids[] = $item['userid'];
	}
	$list = array();
	$bit = $vbulletin->bf_ugp['radiotvpermissions']['canrate'];
	$userids = implode(',', $userids);
	$results = $db->query_read("SELECT *, s.name, u.username, !(BIT_OR(ug.radiotvpermissions) & $bit) as candomagic 
				FROM " . TABLE_PREFIX . "radiostation_rating AS r
				LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = r.userid)
				LEFT JOIN " . TABLE_PREFIX . "usergroup AS ug ON (find_in_set(ug.usergroupid, u.membergroupids) OR (ug.usergroupid = u.usergroupid))
				LEFT JOIN " . TABLE_PREFIX . "radiostation AS s ON (s.stationid = r.stationid)
				WHERE r.userid IN ($userids)
				GROUP BY r.ratingid
				HAVING candomagic > 0");
	while( $item = $db->fetch_array( $results ) ) {
		$list[] = $item;
	}
	return $list;
}

function rs_get_orphan_stations() {
	global $db;
	$list = array();
	$results = $db->query_read("SELECT *, c.cat_name FROM " . TABLE_PREFIX . "radiostation AS s
				LEFT JOIN " . TABLE_PREFIX . "radiostation_category AS c ON (c.categoryid = s.categoryid)
				WHERE c.cat_name IS NULL");
	while( $item = $db->fetch_array( $results ) ) {
		$list[] = $item;
	}
	return $list;
}
?>